---
title: Pulid AI Model Usage Guide
slug: 4IssHB4DIXzEb2LWyU9SY
createdAt: Thu Jul 18 2024 05:48:05 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:45:52 GMT+0000 (Coordinated Universal Time)
---

# Pulid API Usage Guide

## Introduction

This document describes how to use the `aonweb` library to call the `/predictions/ai/pulid` AI model. This model is primarily used for image processing and generation tasks, specifically for processing human images.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
    input: {
        "prompt": "portrait, impressionist painting, loose brushwork, vibrant color, light and shadow play",
        "cfg_scale": 1.2,
        "num_steps": 4,
        "image_width": 768,
        "num_samples": 4,
        "image_height": 1024,
        "output_format": "webp",
        "identity_scale": 0.8,
        "mix_identities": false,
        "output_quality": 80,
        "generation_mode": "fidelity",
        "main_face_image": "https://replicate.delivery/pbxt/Kr6iendsvYS0F3MLmwRZ8q07XIMEJdemnQI3Cmq9nNrauJbq/zcy.webp",
        "negative_prompt": "flaws in the eyes, flaws in the face, flaws, lowres, non-HDRi, low quality, worst quality,artifacts noise, text, watermark, glitch, deformed, mutated, ugly, disfigured, hands, low resolution, partially rendered objects,  deformed or partially rendered eyes, deformed, deformed eyeballs, cross-eyed,blurry"
  }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/pulid@zsxkib", data, price);
     // Handle response
    console.log("pulid result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `prompt`: Text description for generating the image (optional)
- `cfg_scale`: Configuration scale, affecting the match between the generated result and the prompt
- `num_steps`: Number of steps in the generation process
- `image_width`: Width of the output image
- `image_height`: Height of the output image
- `num_samples`: Number of samples generated
- `output_format`: Output image format (e.g., "webp")
- `identity_scale`: Identity scale, affecting the similarity of the generated image to the original image
- `mix_identities`: Whether to mix multiple identities
- `output_quality`: Output image quality (0-100)
- `generation_mode`: Generation mode (e.g., "fidelity")
- `main_face_image`: URL of the main face image
- `negative_prompt`: Negative prompt specifying elements you do not want to appear in the generated image (optional)

### Handling the Response

```js
if (response && response.code == 200 && response.data) {
    const result = response.data;
    if (result.task.exec_code == 200 && result.task.is_success) {
        let url = result.output;
        if (Array.isArray(result.output)) {
            url = result.output[0];
        }
        // Use the generated image URL
    } else {
        // Handle task failure
        const errorMessage = result.task.task_error || result.task.api_error || result.message;
        // Display error message
    }
} else {
    // Handle API call failure
}
```

### Error Handling

Ensure to catch and appropriately handle possible errors:

```js
try {
    // AI model call code
} catch (error) {
    if (typeof error === 'string') {
        console.error(error);
    } else {
        console.error(error.message);
    }
    // Display error message to the user
}
```

## Best Practices

- Ensure users have uploaded valid images before calling the AI model.
- Consider adding a loading indicator as AI processing may take some time.
- Provide reasonable default values for different parameters to simplify user experience.
- Appropriately handle and display AI-generated results, such as showing them in a new page or modal.

### Notes

- Ensure you have enough balance to cover the AI call costs.
- Consider network bandwidth and processing time when handling large images.
- Adhere to the terms and policies of the AI service provider.

## Conclusion

This AI model offers powerful image processing and generation capabilities. By correctly setting parameters and handling responses, you can implement various interesting image transformation features in your application. If you encounter any issues or need further clarification, please refer to the official documentation or contact the support team.
